/****************************************************************************
 *
 *                                 M U E S L I   v 1.4
 *
 *
 *     Copyright 2016 IMDEA Materials Institute, Getafe, Madrid, Spain
 *     Contact: muesli.materials@imdea.org
 *     Author: Ignacio Romero (ignacio.romero@imdea.org)
 *
 *     This file is part of MUESLI.
 *
 *     MUESLI is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     MUESLI is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with MUESLI.  If not, see <http://www.gnu.org/licenses/>.
 *
*****************************************************************************/



#pragma once
#ifndef _muesli_reducedfinitestrain_
#define _muesli_reducedfinitestrain_

#include "finitestrain.h"

#ifdef STRICT_THREAD_SAFE
#include <mutex>
#endif


namespace muesli
{

    class rFiniteStrainMP
    {

    public:
                                rFiniteStrainMP(finiteStrainMP* m);
        virtual                 ~rFiniteStrainMP(){}

        bool                    testImplementation(std::ostream& of=std::cout, const bool testDE=true, const bool testDDE=true) const;
        virtual void            setRandom();


        // energy
        virtual double          dissipatedEnergy() const;
        virtual double          effectiveStoredEnergy() const;
        virtual double          storedEnergy() const;


        // stresses
        virtual void            CauchyStress(istensor &sigma) const;
        virtual void            CauchyStressVector(double sigma[6]) const;
        virtual void            energyMomentumTensor(const itensor& F, itensor& S) const;
        virtual void            firstPiolaKirchhoffStress(itensor &P) const;
        virtual void            KirchhoffStress(istensor &tau) const;
        virtual void            KirchhoffStressVector(double tau[6]) const;
        virtual void            secondPiolaKirchhoffStress(istensor &S) const;
        virtual void            secondPiolaKirchhoffStressVector(double sigma[6]) const = 0;


        // elasticity tangents
        // convected tangent is IC_c = 4 d^2 W(C) / d C^2
        virtual void            convectedTangentMatrix(double c[6][6]) const = 0;


	virtual double          volumetricStiffness() const;



        // bookkeeping
        virtual void            commitCurrentState();
        virtual void            resetCurrentState();
        virtual void            updateCurrentState(const double theTime, itensor& F) = 0;

        itensor&                deformationGradient();
        const itensor&          deformationGradient() const;
        virtual materialState   getConvergedState() const;
        virtual materialState   getCurrentState() const;
        void                    dEdF(itensor4& C) const;


        // miscellaneous
        double                  density() const;
        virtual double          plasticSlip() const;
        virtual double          waveVelocity() const;

    protected:

	finiteStrainMP*			theFiniteStrainMP;
    };

  
    class reduced1zFMP : public muesli::rFiniteStrainMP
    {
      public:
                              reduced1zFMP(finiteStrainMP *mp, int inmapim[5], int inmapiz[1]);
      virtual                 ~reduced1zFMP();

      // three dimensional response
      virtual void            convectedTangentMatrix(double C[6][6]) const;

      // stresses
      virtual void            secondPiolaKirchhoffStressVector(double S[6]) const;

      // bookkeeping
      virtual void            updateCurrentState(const double theTime, itensor& F);

      protected:
        int mapim[5];
        int mapiz[1];
#ifdef STRICT_THREAD_SAFE
    std::mutex              theMutex;
#endif

    };


    class reduced3zFMP : public muesli::rFiniteStrainMP
    {
      public:
                              reduced3zFMP(finiteStrainMP *mp, int inmapim[3], int inmpaiz[3]);
      virtual                 ~reduced3zFMP();

      // three dimensional response
      virtual void            convectedTangentMatrix(double C[6][6]) const;

      // stresses
      virtual void            secondPiolaKirchhoffStressVector(double S[6]) const;

      // bookkeeping
      virtual void            updateCurrentState(const double theTime, itensor& F);

    protected:
      int mapim[3];
      int mapiz[3];
#ifdef STRICT_THREAD_SAFE
    std::mutex              theMutex;
#endif
    };


    class fbeamMP : public muesli::reduced3zFMP
    {
      public:
                            fbeamMP(finiteStrainMP *mp);
      virtual                 ~fbeamMP();

#ifdef STRICT_THREAD_SAFE
    std::mutex              theMutex;
#endif
    };


    class fshellMP : public muesli::reduced1zFMP
    {
      public:
                              fshellMP(finiteStrainMP *mp);
      virtual                 ~fshellMP();

#ifdef STRICT_THREAD_SAFE
    std::mutex              theMutex;
#endif
    };

}
#endif
