/****************************************************************************
 *
 *                                 M U E S L I   v 1.4
 *
 *
 *     Copyright 2016 IMDEA Materials Institute, Getafe, Madrid, Spain
 *     Contact: muesli.materials@imdea.org
 *     Author: Ignacio Romero (ignacio.romero@imdea.org)
 *
 *     This file is part of MUESLI.
 *
 *     MUESLI is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     MUESLI is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with MUESLI.  If not, see <http://www.gnu.org/licenses/>.
 *
*****************************************************************************/


#pragma once
#ifndef _muesli_reducedsmallstrain_
#define _muesli_reducedsmallstrain_

#include "smallstrain.h"
#include <fstream>

#ifdef STRICT_THREAD_SAFE
#include <mutex>
#endif




namespace muesli
{
	
    class rSmallStrainMP
	{

    public:
                               	rSmallStrainMP(smallStrainMP *mp);
        virtual                 ~rSmallStrainMP(){}
        virtual void            setRandom();
        virtual smallStrainMP&  theSmallStrainMP();
        bool                    testImplementation(std::ostream& of=std::cout) const;

        // energies
        virtual double          deviatoricEnergy() const;
        virtual double          dissipatedEnergy() const;
        virtual double          effectiveStoredEnergy() const;
        virtual double          storedEnergy() const;
        virtual double          volumetricEnergy() const;


        // stress
        virtual double          pressure() const;
        virtual void            stress(istensor& sigma) const;
        virtual void            stressVector(double S[6]) const = 0;
        virtual void            deviatoricStress(istensor& s) const;
        virtual double          plasticSlip() const;


        // tangents
        virtual void            tangentMatrix(double C[6][6]) const = 0;


        // bookkeeping
        virtual void            commitCurrentState();
        virtual void            resetCurrentState();
        virtual void            updateCurrentState(const double t, istensor& strain) = 0;


        istensor&               getCurrentStrain();
        const istensor&         getCurrentStrain() const;
        virtual materialState   getConvergedState() const;
        virtual materialState   getCurrentState() const;

        const smallStrainMaterial& parentMaterial() const;


    protected:
		smallStrainMP*			_theSmallStrainMP;
    };



    // reduced modesl with 1 zero in the stress tensor
    class reduced1zSMP : public muesli::rSmallStrainMP
    {
      public:
                              reduced1zSMP(smallStrainMP *mp, int inmapim[5], int inmapiz[1]);
      virtual                 ~reduced1zSMP();

      // three dimensional response
      virtual void            tangentMatrix(double C[6][6]) const;

      // stresses
      virtual void            stressVector(double S[6]) const;

      // bookkeeping
      virtual void            updateCurrentState(const double theTime, istensor& strain);

      protected:
        int mapim[5];
        int mapiz[1];
#ifdef STRICT_THREAD_SAFE
    std::mutex              theMutex;
#endif
    };



  
    // reduced modesl with 3 zeros in the stress tensor
    class reduced3zSMP : public muesli::rSmallStrainMP
    {
      public:
                              reduced3zSMP(smallStrainMP *mp, int inmapim[3], int inmpaiz[3]);
      virtual                 ~reduced3zSMP();

      // three dimensional response
      virtual void            tangentMatrix(double C[6][6]) const;

      // stresses
      virtual void            stressVector(double S[6]) const;

      // bookkeeping
      virtual void            updateCurrentState(const double theTime, istensor& strain);

      protected:
        int mapim[3];
        int mapiz[3];
#ifdef STRICT_THREAD_SAFE
    std::mutex              theMutex;
#endif
    };




    class sbeamMP : public muesli::reduced3zSMP
    {
      public:
                            sbeamMP(smallStrainMP *mp);
      
#ifdef STRICT_THREAD_SAFE
    std::mutex              theMutex;
#endif

    };




    class sshellMP : public muesli::reduced1zSMP
    {
      public:
                            sshellMP(smallStrainMP *mp);

#ifdef STRICT_THREAD_SAFE
    std::mutex              theMutex;
#endif
    };
}


#endif

