/****************************************************************************
 *
 *                                 M U E S L I   v 1.4
 *
 *
 *     Copyright 2016 IMDEA Materials Institute, Getafe, Madrid, Spain
 *     Contact: muesli.materials@imdea.org
 *     Author: Ignacio Romero (ignacio.romero@imdea.org)
 *
 *     This file is part of MUESLI.
 *
 *     MUESLI is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     MUESLI is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with MUESLI.  If not, see <http://www.gnu.org/licenses/>.
 *
*****************************************************************************/



#include <iostream>
#include <ctime>
#include <cstdlib>
#include <unistd.h>

#include "muesli/muesli.h"

int main(int argc, char **argv)
{
    std::ofstream os("testmuesli.log");

    // header
    os << "            M U E S L I    T E S T S\n\n";
    time_t walltime = time(NULL);
    os << " Test done on : " << ctime(&walltime);
    os << " Username     : " << getlogin();

    char host[256];
    if (gethostname( host, 256) == 0)
    {
        os << "\n Hostname     : " << host;
    }
    else
    {
        os << "\n Hostname     : unknown";
    }

    static char noOS[] = "UNKNOWN OS";
    char *op = getenv("OSTYPE");
    if (op == NULL) op = getenv("OS");
    if (op == NULL) op = noOS;
    os << "\n OS           : " << op;


    bool isok = true;
    {
        muesli::materialProperties mp;
        std::string name = "elastic material";
        muesli::elasticIsotropicMaterial* m = new muesli::elasticIsotropicMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing smallstrain isotropic elastic material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        muesli::materialProperties mp;
        std::string name = "anisotropic material";
        muesli::elasticAnisotropicMaterial* m = new muesli::elasticAnisotropicMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing smallstrain anisotropic elastic material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        muesli::materialProperties mp;
        std::string name = "orthotropic material";
        muesli::elasticOrthotropicMaterial* m = new muesli::elasticOrthotropicMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing smallstrain orthotropic elastic material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        muesli::materialProperties mp;
        std::string name = "visco elastic material";
        muesli::viscoelasticMaterial* m = new muesli::viscoelasticMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing smallstrain visco elastic material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        muesli::materialProperties mp;
        std::string name = "a plastic material";
        muesli::splasticMaterial* m = new muesli::splasticMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing smallstrain elasto plastic material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        std::string name = "a viscoplastic material";
        muesli::materialProperties mp;
        muesli::viscoplasticMaterial* m = new muesli::viscoplasticMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing smallstrain elasto visco plastic material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        std::string name = "a SV-K material";
        muesli::materialProperties mp;
        muesli::svkMaterial* m = new muesli::svkMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing Saint Venant - Kirchhoff material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        std::string name = "a neohookean material";
        muesli::materialProperties mp;
        muesli::neohookeanMaterial* m = new muesli::neohookeanMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing Neohookean material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        std::string name = "a mooney rivlin material";
        muesli::materialProperties mp;
        muesli::mooneyMaterial* m = new muesli::mooneyMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing Mooney - Rivlin material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        std::string name = "an arruda boyce material";
        muesli::materialProperties mp;
        muesli::arrudaboyceMaterial* m = new muesli::arrudaboyceMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing Arruda - Boyce material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        std::string name = "a Yeoh material";
        muesli::materialProperties mp;
        muesli::yeohMaterial* m = new muesli::yeohMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing Yeoh material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        std::string name = "a fs elastoplastic material";
        muesli::materialProperties mp;
        muesli::fplasticMaterial* m = new muesli::fplasticMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing finite strain elastoplastic material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        std::string name = "a small strain thermomechanical material";
        muesli::materialProperties mp;
        muesli::thermomechanicalMaterial* m = new muesli::thermomechanicalMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing small strain thermomechanical material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        std::string name = "a conductor material";
        muesli::conductorMaterial* m = new muesli::conductorMaterial(name);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing conductor material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    {
        std::string name = "a newtonian fluid material";
        muesli::newtonianMaterial* m = new muesli::newtonianMaterial(name);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing newtonian material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
	}

    {
        std::string name = "a finite strain thermomechanical material";
        muesli::materialProperties mp;
        muesli::thermofiniteStrainMaterial* m = new muesli::thermofiniteStrainMaterial(name, mp);
        os << "\n";
        os << "\n----------------------------------------------------";
        os << "\n Testing finite strain, thermomechanical material";
        os << "\n----------------------------------------------------";
        bool mok = m->test(os);
        isok = isok && mok;
        delete m;
    }

    return 0;
}


