/****************************************************************************
 *
 *                                 M U E S L I   v 1.4
 *
 *
 *     Copyright 2016 IMDEA Materials Institute, Getafe, Madrid, Spain
 *     Contact: muesli.materials@imdea.org
 *     Author: Ignacio Romero (ignacio.romero@imdea.org)
 *
 *     This file is part of MUESLI.
 *
 *     MUESLI is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     MUESLI is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with MUESLI.  If not, see <http://www.gnu.org/licenses/>.
 *
*****************************************************************************/









#ifndef _muesli_conductor_h
#define _muesli_conductor_h


#include "muesli/material.h"
#include "muesli/tensor.h"
#include <iostream>

namespace muesli
{

    class conductorMP;

    class conductorMaterial : public muesli::material
    {
    public:
                                    conductorMaterial(const std::string& name);
                                    conductorMaterial(const std::string& name,
                                                      const materialProperties& cl);
                                    conductorMaterial(const std::string& name, const double k, const double rho);

        virtual                     ~conductorMaterial() {}

        virtual bool                check() const;
        const double&               conductivity() const;
        virtual conductorMP*        createMaterialPoint() const;
        virtual double              density() const;
        double                      getProperty(const propertyName p) const;
        const double&               heatCapacity() const;
        virtual void                print(std::ostream &of=std::cout) const;
        virtual void                setRandom();
        virtual bool                test(std::ostream& os=std::cout);

    private:
        double                      _conductivity, _density, _capacity;
#ifdef STRICT_THREAD_SAFE
        std::mutex                  theMutex;
#endif
        friend class                conductorMP;
    };




    class conductorMP : public muesli::materialPoint
    {

    public:

                                    conductorMP(const conductorMaterial& mat);

        // energy
        double                      thermalEnergy() const;
        void                        heatflux(ivector &q) const;

        // tangent operation
        void                        contractTangent(const ivector& na,
                                                    const ivector& nb, double& tg) const;

        const conductorMaterial*    getMaterial(){return mat;}
        double                      density() const;


        // tests
        virtual void                setRandom();
        virtual bool                testImplementation(std::ostream& os) const;


        // updates
        virtual materialState       getConvergedState() const;
        virtual materialState       getCurrentState() const;
        virtual void                commitCurrentState();
        virtual void                resetCurrentState();
        virtual void                updateCurrentState(const double theTime, const ivector& gradT);


    private:
        conductorMaterial const*    mat;
        double                      time_n;     // time for internal variables:
        ivector                     gradT_n;    // temperature gradient at tn
        
        double                      time_c;     // time for internal variables:
        ivector                     gradT_c;    // temperature gradient at tn

#ifdef STRICT_THREAD_SAFE
        std::mutex                  theMutex;
#endif
    };
}

#endif

